/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class WindowOptions
implements Cloneable {
    public static final String VALID_BOOLEAN_OPTIONS = " directories location menubar resizable scrollbars status toolbar ";
    public static final String VALID_INT_OPTIONS = " width height left top screenx screeny relativewidth relativeheight ";
    public static final String EXTENDED_OPTIONS = " relativewidth relativeheight ";
    protected HashMap _options = new HashMap();
    protected String _validBooleanOptions = " directories location menubar resizable scrollbars status toolbar ";
    protected String _validIntOptions = " width height left top screenx screeny relativewidth relativeheight ";
    protected String _extendedOptions = " relativewidth relativeheight ";

    public void putProperties(Properties props) throws IllegalArgumentException {
        StringBuffer msgs = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> property = i.next();
            try {
                this.setOption((String)property.getKey(), (String)property.getValue());
            }
            catch (Exception e) {
                if (msgs.equals("")) {
                    msgs.append("The following window options are invalid:  \n");
                } else {
                    msgs.append("\n");
                }
                msgs.append(e.getMessage());
            }
        }
        if (msgs.length() != 0) {
            throw new IllegalArgumentException(msgs.toString());
        }
    }

    public boolean validBooleanOption(String optionName) {
        return this._validBooleanOptions.indexOf(" " + optionName + " ") != -1;
    }

    public boolean validIntOption(String optionName) {
        return this._validIntOptions.indexOf(" " + optionName + " ") != -1;
    }

    public boolean extendedOption(String optionName) {
        return this._extendedOptions.indexOf(" " + optionName + " ") != -1;
    }

    public void setOption(String optionName, String optionValue) throws IllegalArgumentException {
        optionName = optionName.toLowerCase();
        optionValue = optionValue.toLowerCase();
        if (this.validBooleanOption(optionName)) {
            if (!optionValue.equals("yes") && !optionValue.equals("no")) {
                throw new IllegalArgumentException("Option value for " + optionName + " must be 'yes' or 'no'.");
            }
        } else if (this.validIntOption(optionName)) {
            try {
                Integer.parseInt(optionValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Option value for " + optionName + " must be an integer.");
            }
        } else {
            throw new IllegalArgumentException("Option name " + optionName + " is not valid.");
        }
        if (optionName.equals("screenx") || optionName.equals("left")) {
            this._options.put("screenx", optionValue);
            this._options.put("left", optionValue);
        } else if (optionName.equals("screeny") || optionName.equals("top")) {
            this._options.put("screeny", optionValue);
            this._options.put("top", optionValue);
        } else {
            this._options.put(optionName, optionValue);
        }
    }

    public void removeOption(String optionName) {
        this._options.remove(optionName.toLowerCase());
    }

    private Boolean getBooleanValue(String key) {
        Boolean result = null;
        String value = (String)this._options.get(key);
        if (value != null) {
            result = new Boolean(value.equals("yes"));
        }
        return result;
    }

    private Integer getIntValue(String key) {
        Integer result = null;
        String value = (String)this._options.get(key);
        if (value != null) {
            result = new Integer(value);
        }
        return result;
    }

    private void setIntValue(String key, int value) {
        this._options.put(key, Integer.toString(value));
    }

    private void setBooleanValue(String key, boolean value) {
        this._options.put(key, value ? "yes" : "no");
    }

    public void setLeft(int left) {
        this.setIntValue("left", left);
        this.setIntValue("screenx", left);
    }

    public void setScreenX(int left) {
        this.setLeft(left);
    }

    public void setTop(int top) {
        this.setIntValue("top", top);
        this.setIntValue("screeny", top);
    }

    public void setScreenY(int top) {
        this.setTop(top);
    }

    public Integer getLeft() {
        return this.getIntValue("left");
    }

    public Integer getScreenX() {
        return this.getIntValue("screenx");
    }

    public Integer getTop() {
        return this.getIntValue("top");
    }

    public Integer getScreenY() {
        return this.getIntValue("screeny");
    }

    public void setDirectories(boolean setting) {
        this.setBooleanValue("directories", setting);
    }

    public Boolean hasDirectories() {
        return this.getBooleanValue("directories");
    }

    public void setHeight(int setting) {
        this.setIntValue("height", setting);
    }

    public Integer getHeight() {
        return this.getIntValue("height");
    }

    public void setLocation(boolean setting) {
        this.setBooleanValue("location", setting);
    }

    public Boolean hasLocation() {
        return this.getBooleanValue("location");
    }

    public void setMenubar(boolean setting) {
        this.setBooleanValue("menubar", setting);
    }

    public Boolean hasMenubar() {
        return this.getBooleanValue("menubar");
    }

    public void setResizable(boolean setting) {
        this.setBooleanValue("resizable", setting);
    }

    public Boolean isResizable() {
        return this.getBooleanValue("resizable");
    }

    public void setScrollbars(boolean setting) {
        this.setBooleanValue("scrollbars", setting);
    }

    public Boolean hasScrollbars() {
        return this.getBooleanValue("scrollbars");
    }

    public void setStatus(boolean setting) {
        this.setBooleanValue("status", setting);
    }

    public Boolean hasStatus() {
        return this.getBooleanValue("status");
    }

    public void setToolbar(boolean setting) {
        this.setBooleanValue("toolbar", setting);
    }

    public Boolean hasToolbar() {
        return this.getBooleanValue("toolbar");
    }

    public void setWidth(int setting) {
        this.setIntValue("width", setting);
    }

    public Integer getWidth() {
        return this.getIntValue("width");
    }

    public Integer getRelativeWidth() {
        return this.getIntValue("relativewidth");
    }

    public Integer getRelativeHeight() {
        return this.getIntValue("relativeheight");
    }

    public void setRelativeWidth(int width) {
        this.setIntValue("relativewidth", width);
    }

    public void setRelativeHeight(int height) {
        this.setIntValue("relativeheight", height);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator options = this._options.entrySet().iterator();
        while (options.hasNext()) {
            Map.Entry entry = options.next();
            String key = (String)entry.getKey();
            if (this.extendedOption(key)) continue;
            if (result.length() != 0) {
                result.append(",");
            }
            result.append(key);
            result.append("=");
            result.append((String)entry.getValue());
        }
        return result.toString();
    }

    public Object clone() {
        try {
            WindowOptions newObject = (WindowOptions)super.clone();
            newObject._options = (HashMap)this._options.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

